package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

public class ConveyorPaletteObject extends ScreenPaletteObject {
	
	
	private boolean isGoingLeft;
	private int speed;
	private boolean isPassThru;
	private CustomImageDataII[] animation;
	
	private ArrayList<ConveyorScreenObject> createdObjects;
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		ConveyorScreenObject returnValue = new ConveyorScreenObject(objX, objY, this);
		createdObjects.add(returnValue);
		return returnValue;
	}

	@Override
	public void delete(ScreenObject so) {
		createdObjects.remove(so);
	}

	@Override
	public void draw(Graphics g) {
		
		if(clickRect == null)
			return;
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
		
	}
	
	public ConveyorPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, CustomImageDataII [] images, boolean isFacingLeftFlag, int theSpeed, boolean isPassThruFlag) {
		
		animation = images;
		image = images[0];
		clickRect = theClickRect;
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		speed = theSpeed;
		isGoingLeft = isFacingLeftFlag;
		isPassThru = isPassThruFlag;
		
		createdObjects = new ArrayList<ConveyorScreenObject>();
		
	}
	
	public CustomImageDataII getImage() {
		return image;
	}
	
	
	public void setImages(CustomImageDataII [] newImages) {
		
		int oldWidth = animation[0].getDesiredWidth();
		int oldHeight = animation[0].getDesiredHeight();
		
		animation = newImages;
		
		image = animation[0];
		
		int newWidth = animation[0].getDesiredWidth();
		int newHeight = animation[0].getDesiredHeight();
		
		if(oldWidth != newWidth || oldHeight != newHeight) {
			
			for(ConveyorScreenObject o : createdObjects) {
				o.changeSize(newWidth, newHeight);
			}
			
		}
		
		
	}

	public boolean isGoingLeft() {
		return isGoingLeft;
	}

	public void setGoingLeft(boolean isGoingLeft) {
		this.isGoingLeft = isGoingLeft;
	}

	public int getSpeed() {
		return speed;
	}

	public void setSpeed(int speed) {
		this.speed = speed;
	}

	public boolean isPassThru() {
		return isPassThru;
	}

	public void setPassThru(boolean isPassThru) {
		this.isPassThru = isPassThru;
	}
	
	
	public CustomImageDataII [] getAnimation() {
		return animation;
	}
	
}
